package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * collection_order_type
 * </p>
 *
 * @author ultraman
 * @since 2024-11-20
 */
public enum CollectionOrderType {

    _0("0", "收款单"),
    _1("1", "合同负债");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CollectionOrderType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CollectionOrderType fromCode(String code) {
        return Stream.of(CollectionOrderType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
