package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ebs_documents_type
 * </p>
 *
 * @author ultraman
 * @since 2024-11-20
 */
public enum EbsDocumentsType {

    _1("1", "销售订单"),
    _2("2", "退货订单"),
    _3("3", "收款单"),
    _4("4", "其他业务收入"),
    _5("5", "费用"),
    _6("6", "其他"),
    _7("7", "收款单（合同负债）");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    EbsDocumentsType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EbsDocumentsType fromCode(String code) {
        return Stream.of(EbsDocumentsType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
