package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * handle_type
 * </p>
 *
 * @author ultraman
 * @since 2024-11-20
 */
public enum HandleType {

    JSONPATH("jsonpath", "jsonpath"),
    JS("js", "js");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    HandleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static HandleType fromCode(String code) {
        return Stream.of(HandleType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
