package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ks_co_type
 * </p>
 *
 * @author ultraman
 * @since 2024-11-20
 */
public enum KsCoType {

    _0("0", "未知"),
    _2("2", "券包"),
    _3("3", "话费充值"),
    _8("8", "跨境"),
    _24("24", "预约有价优惠券");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    KsCoType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static KsCoType fromCode(String code) {
        return Stream.of(KsCoType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
