package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * business_group
 * </p>
 *
 * @author ultraman
 * @since 2024-11-20
 */
public enum BusinessGroup {

    _1("1", "健康"),
    _2("2", "器械");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BusinessGroup(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BusinessGroup fromCode(String code) {
        return Stream.of(BusinessGroup.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
