package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * check_result
 * </p>
 *
 * @author ultraman
 * @since 2024-11-20
 */
public enum CheckResult {

    _0("0", "允差外不通过"),
    _1("1", "允差内通过"),
    _9("9", "对账异常");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CheckResult(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CheckResult fromCode(String code) {
        return Stream.of(CheckResult.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
