package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_check_biz_type
 * </p>
 *
 * @author ultraman
 * @since 2024-11-20
 */
public enum DyCheckBizType {

    _0("0", "全部"),
    _1("1", "鲁班广告"),
    _2("2", "精选联盟"),
    _3("3", "值点商城"),
    _4("4", "小店自卖"),
    _5("5", "橙子建站"),
    _6("6", "POI"),
    _7("7", "抖+"),
    _8("8", "穿山甲"),
    _9("9", "服务市场"),
    _10("10", "服务市场外包客服"),
    _11("11", "学浪");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DyCheckBizType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyCheckBizType fromCode(String code) {
        return Stream.of(DyCheckBizType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
