package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_goods_type
 * </p>
 *
 * @author ultraman
 * @since 2024-11-20
 */
public enum DyGoodsType {

    _0("0", "实体"),
    _1("1", "虚拟");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DyGoodsType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyGoodsType fromCode(String code) {
        return Stream.of(DyGoodsType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
