package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * jky_logistic_type
 * </p>
 *
 * @author ultraman
 * @since 2024-11-20
 */
public enum JkyLogisticType {

    _1("1", "普通快递"),
    _2("2", "上门自提"),
    _3("3", "门店配送"),
    _5("5", "无需配送"),
    _6("6", "线下配送"),
    _7("7", "自有物流");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    JkyLogisticType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static JkyLogisticType fromCode(String code) {
        return Stream.of(JkyLogisticType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
