package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * jky_trade_status
 * </p>
 *
 * @author ultraman
 * @since 2024-11-20
 */
public enum JkyTradeStatus {

    _1010("1010", "待审核"),
    _1020("1020", "审核中"),
    _1030("1030", "预售"),
    _1050("1050", "待复核"),
    _2000("2000", "备货等待"),
    _2010("2010", "备货等待等补货"),
    _2020("2020", "服务等待"),
    _2030("2030", "备货等待等生产"),
    _2040("2040", "采购等待"),
    _3010("3010", "虚拟发货"),
    _4110("4110", "待发货待递交"),
    _4111("4111", "待发货递交中"),
    _4112("4112", "待发货已递交"),
    _4113("4113", "待发货-递交失败"),
    _4121("4121", "待发货-取消中"),
    _4122("4122", "待发货已取消"),
    _4123("4123", "待发货取消失败"),
    _4130("4130", "待发货部分发货"),
    _4040("4040", "代销发货待递交"),
    _4041("4041", "代销发货已递交"),
    _5010("5010", "已取消"),
    _5020("5020", "已取消被合并"),
    _5030("5030", "已取消被拆分"),
    _6000("6000", "发货在途"),
    _9090("9090", "已完成");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    JkyTradeStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static JkyTradeStatus fromCode(String code) {
        return Stream.of(JkyTradeStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
