package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * price_type
 * </p>
 *
 * @author ultraman
 * @since 2024-11-20
 */
public enum PriceType {

    _1("1", "开票价"),
    _2("2", "零售价"),
    _3("3", "成本价");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PriceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PriceType fromCode(String code) {
        return Stream.of(PriceType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
