package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * write_off_status
 * </p>
 *
 * @author ultraman
 * @since 2024-11-20
 */
public enum WriteOffStatus {

    _0("0", "未核销"),
    _1("1", "部分核销"),
    _2("2", "已核销");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    WriteOffStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static WriteOffStatus fromCode(String code) {
        return Stream.of(WriteOffStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
