package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * contract_debt_flag
 * </p>
 *
 * @author ultraman
 * @since 2024-12-04
 */
public enum ContractDebtFlag {

    NO("no", "否"),
    YES("yes", "是");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ContractDebtFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ContractDebtFlag fromCode(String code) {
        return Stream.of(ContractDebtFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
