package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_check_account_bill_desc_tag
 * </p>
 *
 * @author ultraman
 * @since 2024-12-04
 */
public enum DyCheckAccountBillDescTag {

    _0("0", "其他"),
    _1("1", "达人带货佣金"),
    _2("2", "达人佣金退款"),
    _3("3", "订单结算"),
    _4("4", "部分结算"),
    _5("5", "运费单结算"),
    _6("6", "服务费返还"),
    _7("7", "平台补贴扣回"),
    _8("8", "退款失败退票"),
    _9("9", "结算重复扣款调账"),
    _10("10", "保证金退款"),
    _11("11", "提现"),
    _12("12", "提现退票"),
    _13("13", "极速退款分账"),
    _14("14", "小额打款(原因:补差价)"),
    _15("15", "小额打款(原因:其他)"),
    _16("16", "小额打款(原因:商品补偿)"),
    _17("17", "小额打款(原因:运费补偿)"),
    _18("18", "小额打款退票"),
    _19("19", "已退款"),
    _20("20", "运费险扣减货款"),
    _21("21", "支付BIC服务费"),
    _22("22", "BIC服务费退票"),
    _23("23", "原路退");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DyCheckAccountBillDescTag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyCheckAccountBillDescTag fromCode(String code) {
        return Stream.of(DyCheckAccountBillDescTag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
