package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_is_agree_refuse_sign
 * </p>
 *
 * @author ultraman
 * @since 2024-12-04
 */
public enum DyIsAgreeRefuseSign {

    _1("1", "已同意拒签"),
    _0("0", "无"),
    _2("2", "未同意拒签");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DyIsAgreeRefuseSign(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyIsAgreeRefuseSign fromCode(String code) {
        return Stream.of(DyIsAgreeRefuseSign.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
