package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_pay_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-04
 */
public enum DyPayType {

    _0("0", "货到付款"),
    _1("1", "微信"),
    _2("2", "支付宝"),
    _3("3", "小程序"),
    _4("4", "银行卡"),
    _5("5", "余额"),
    _7("7", "无需支付（0元单）"),
    _8("8", "DOU分期（信用支付）"),
    _9("9", "新卡支付"),
    _12("12", "先用后付"),
    _16("16", "收银台支付"),
    _10("10", "-"),
    _11("11", "-"),
    _13("13", "-"),
    _14("14", "-"),
    _15("15", "-"),
    _17("17", "-"),
    _18("18", "-");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DyPayType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyPayType fromCode(String code) {
        return Stream.of(DyPayType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
