package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_trade_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-04
 */
public enum DyTradeType {

    _0("0", "普通"),
    _1("1", "拼团"),
    _2("2", "定金预售"),
    _3("3", "定金找货"),
    _4("4", "拍卖"),
    _5("5", "0元单"),
    _6("6", "回收"),
    _7("7", "寄卖"),
    _10("10", "寄样"),
    _11("11", "零元抽奖"),
    _12("12", "达人买样"),
    _13("13", "普通定制"),
    _16("16", "大众竞拍"),
    _18("18", "小时达"),
    _102("102", "定金预售的赠品单"),
    _103("103", "收款");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DyTradeType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyTradeType fromCode(String code) {
        return Stream.of(DyTradeType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
