package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * erp_return_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-04
 */
public enum ErpReturnStatus {

    _0("0", "待回传"),
    _1("1", "回传中"),
    _2("2", "已回传");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ErpReturnStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ErpReturnStatus fromCode(String code) {
        return Stream.of(ErpReturnStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
