package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ksrefundstatus
 * </p>
 *
 * @author ultraman
 * @since 2024-12-04
 */
public enum Ksrefundstatus {

    _10("10", "买家已经申请退款，等待卖家同意"),
    _12("12", "卖家已拒绝，等待买家处理"),
    _20("20", "协商纠纷，等待平台处理"),
    _30("30", "卖家已经同意退款，等待买家退货"),
    _40("40", "买家已经退货，等待卖家确认收货"),
    _45("45", "卖家已经发货，等待买家确认收货"),
    _50("50", "卖家已经同意退款，等待系统执行退款"),
    _60("60", "退款成功"),
    _70("70", "退款关闭");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Ksrefundstatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Ksrefundstatus fromCode(String code) {
        return Stream.of(Ksrefundstatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
