package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * receivable_order_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-04
 */
public enum ReceivableOrderStatus {

    _1("1", "待发货");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ReceivableOrderStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReceivableOrderStatus fromCode(String code) {
        return Stream.of(ReceivableOrderStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
