package com.xforceplus.ultraman.app.policymanagement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * check_config
 * </p>
 *
 * @author ultraman
 * @since 2024-12-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class CheckConfig implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 电商平台
   */
  private String ecChannel;
  /**
   * 白药公司名
   */
  private String companyName;
  /**
   * 组织ID
   */
  private Long orgId;
  /**
   * 销售订单对账允差最小值
   */
  private BigDecimal salesOrderCheckDiffMin;
  /**
   * 销售订单对账允差最大值
   */
  private BigDecimal salesOrderCheckDiffMax;
  /**
   * 售后单对账允差最小值
   */
  private BigDecimal afterSalesOrderCheckDiffMin;
  /**
   * 售后单对账允差最大值
   */
  private BigDecimal afterSalesOrderCheckDiffMax;
  /**
   * 订单应收对账允差最小值
   */
  private BigDecimal receivableCheckDiffMin;
  /**
   * 订单应收对账允差最大值
   */
  private BigDecimal receivableCheckDiffMax;
  /**
   * 售后单应收对账允差最小值
   */
  private BigDecimal afterSalesReceivableCheckDiffMin;
  /**
   * 售后单收对账允差最大值
   */
  private BigDecimal afterSalesReceivableCheckDiffMax;
  /**
   * 允差内自动确认订单应收
   */
  private String createReceivableEnable;
  /**
   * 允差内自动确认售后应收
   */
  private String createAfterReceivableEnable;
  /**
   * 允差内自动生成应收调整单
   */
  private String createReceivableAdjustEnable;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 组织树
   */
  private String orgTree;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("ec_channel", ecChannel);
      map.put("company_name", companyName);
      map.put("org_id", orgId);
      map.put("sales_order_check_diff_min", salesOrderCheckDiffMin);
      map.put("sales_order_check_diff_max", salesOrderCheckDiffMax);
      map.put("after_sales_order_check_diff_min", afterSalesOrderCheckDiffMin);
      map.put("after_sales_order_check_diff_max", afterSalesOrderCheckDiffMax);
      map.put("receivable_check_diff_min", receivableCheckDiffMin);
      map.put("receivable_check_diff_max", receivableCheckDiffMax);
      map.put("after_sales_receivable_check_diff_min", afterSalesReceivableCheckDiffMin);
      map.put("after_sales_receivable_check_diff_max", afterSalesReceivableCheckDiffMax);
      map.put("create_receivable_enable", createReceivableEnable);
      map.put("create_after_receivable_enable", createAfterReceivableEnable);
      map.put("create_receivable_adjust_enable", createReceivableAdjustEnable);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static CheckConfig fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    CheckConfig entity = new CheckConfig();

    if(map.containsKey("ec_channel")) {
      Object obj = map.get("ec_channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEcChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sales_order_check_diff_min")) {
      Object obj = map.get("sales_order_check_diff_min");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalesOrderCheckDiffMin((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalesOrderCheckDiffMin(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalesOrderCheckDiffMin(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesOrderCheckDiffMin(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesOrderCheckDiffMin(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sales_order_check_diff_max")) {
      Object obj = map.get("sales_order_check_diff_max");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalesOrderCheckDiffMax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalesOrderCheckDiffMax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalesOrderCheckDiffMax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesOrderCheckDiffMax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesOrderCheckDiffMax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("after_sales_order_check_diff_min")) {
      Object obj = map.get("after_sales_order_check_diff_min");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAfterSalesOrderCheckDiffMin((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAfterSalesOrderCheckDiffMin(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAfterSalesOrderCheckDiffMin(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAfterSalesOrderCheckDiffMin(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAfterSalesOrderCheckDiffMin(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("after_sales_order_check_diff_max")) {
      Object obj = map.get("after_sales_order_check_diff_max");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAfterSalesOrderCheckDiffMax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAfterSalesOrderCheckDiffMax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAfterSalesOrderCheckDiffMax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAfterSalesOrderCheckDiffMax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAfterSalesOrderCheckDiffMax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("receivable_check_diff_min")) {
      Object obj = map.get("receivable_check_diff_min");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReceivableCheckDiffMin((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReceivableCheckDiffMin(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReceivableCheckDiffMin(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceivableCheckDiffMin(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReceivableCheckDiffMin(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("receivable_check_diff_max")) {
      Object obj = map.get("receivable_check_diff_max");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReceivableCheckDiffMax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReceivableCheckDiffMax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReceivableCheckDiffMax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceivableCheckDiffMax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReceivableCheckDiffMax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("after_sales_receivable_check_diff_min")) {
      Object obj = map.get("after_sales_receivable_check_diff_min");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAfterSalesReceivableCheckDiffMin((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAfterSalesReceivableCheckDiffMin(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAfterSalesReceivableCheckDiffMin(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAfterSalesReceivableCheckDiffMin(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAfterSalesReceivableCheckDiffMin(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("after_sales_receivable_check_diff_max")) {
      Object obj = map.get("after_sales_receivable_check_diff_max");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAfterSalesReceivableCheckDiffMax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAfterSalesReceivableCheckDiffMax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAfterSalesReceivableCheckDiffMax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAfterSalesReceivableCheckDiffMax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAfterSalesReceivableCheckDiffMax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("create_receivable_enable")) {
      Object obj = map.get("create_receivable_enable");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateReceivableEnable((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_after_receivable_enable")) {
      Object obj = map.get("create_after_receivable_enable");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateAfterReceivableEnable((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_receivable_adjust_enable")) {
      Object obj = map.get("create_receivable_adjust_enable");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateReceivableAdjustEnable((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("ec_channel")) {
      Object obj = map.get("ec_channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setEcChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setOrgId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sales_order_check_diff_min")) {
      Object obj = map.get("sales_order_check_diff_min");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setSalesOrderCheckDiffMin((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setSalesOrderCheckDiffMin(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setSalesOrderCheckDiffMin(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSalesOrderCheckDiffMin(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setSalesOrderCheckDiffMin(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sales_order_check_diff_max")) {
      Object obj = map.get("sales_order_check_diff_max");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setSalesOrderCheckDiffMax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setSalesOrderCheckDiffMax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setSalesOrderCheckDiffMax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSalesOrderCheckDiffMax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setSalesOrderCheckDiffMax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("after_sales_order_check_diff_min")) {
      Object obj = map.get("after_sales_order_check_diff_min");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAfterSalesOrderCheckDiffMin((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAfterSalesOrderCheckDiffMin(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAfterSalesOrderCheckDiffMin(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAfterSalesOrderCheckDiffMin(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAfterSalesOrderCheckDiffMin(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("after_sales_order_check_diff_max")) {
      Object obj = map.get("after_sales_order_check_diff_max");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAfterSalesOrderCheckDiffMax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAfterSalesOrderCheckDiffMax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAfterSalesOrderCheckDiffMax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAfterSalesOrderCheckDiffMax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAfterSalesOrderCheckDiffMax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("receivable_check_diff_min")) {
      Object obj = map.get("receivable_check_diff_min");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setReceivableCheckDiffMin((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setReceivableCheckDiffMin(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setReceivableCheckDiffMin(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setReceivableCheckDiffMin(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setReceivableCheckDiffMin(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("receivable_check_diff_max")) {
      Object obj = map.get("receivable_check_diff_max");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setReceivableCheckDiffMax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setReceivableCheckDiffMax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setReceivableCheckDiffMax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setReceivableCheckDiffMax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setReceivableCheckDiffMax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("after_sales_receivable_check_diff_min")) {
      Object obj = map.get("after_sales_receivable_check_diff_min");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAfterSalesReceivableCheckDiffMin((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAfterSalesReceivableCheckDiffMin(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAfterSalesReceivableCheckDiffMin(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAfterSalesReceivableCheckDiffMin(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAfterSalesReceivableCheckDiffMin(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("after_sales_receivable_check_diff_max")) {
      Object obj = map.get("after_sales_receivable_check_diff_max");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAfterSalesReceivableCheckDiffMax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAfterSalesReceivableCheckDiffMax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAfterSalesReceivableCheckDiffMax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAfterSalesReceivableCheckDiffMax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAfterSalesReceivableCheckDiffMax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("create_receivable_enable")) {
      Object obj = map.get("create_receivable_enable");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateReceivableEnable((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_after_receivable_enable")) {
      Object obj = map.get("create_after_receivable_enable");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateAfterReceivableEnable((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_receivable_adjust_enable")) {
      Object obj = map.get("create_receivable_adjust_enable");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateReceivableAdjustEnable((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
  }
}
