package com.xforceplus.ultraman.app.policymanagement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * platform_subsidy_invoice_settlement
 * </p>
 *
 * @author ultraman
 * @since 2024-12-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PlatformSubsidyInvoiceSettlement implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 补贴名称
   */
  private String subsidyName;
  /**
   * 发生期间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime occurrencePeriod;
  /**
   * 发票号码
   */
  private String invoiceNo;
  /**
   * 发票项目名称
   */
  private String invoiceProjectName;
  /**
   * 发票含税金额
   */
  private BigDecimal amountWithTax;
  /**
   * 税率
   */
  private String taxRate;
  /**
   * 开票日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invoiceTime;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 组织树
   */
  private String orgTree;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 门店编码
   */
  private String storeId;
  /**
   * 门店名称
   */
  private String storeName;
  /**
   * 入账项目名称
   */
  private String accountName;
  /**
   * 关联电商销售订单号
   */
  private String orderNo;
  /**
   * 汇总日
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime summaryDate;
  /**
   * 票结类型
   */
  private String closingType;
  /**
   * EBS回传状态
   */
  private String ebsReturn;
  /**
   * 凭证号
   */
  private String documentNo;
  /**
   * 凭证类型
   */
  private String documentType;
  /**
   * 异常信息
   */
  private String abnormalInfo;
  /**
   * 扩展字段1
   */
  private String subsidyext1;
  /**
   * 扩展字段2
   */
  private String subsidyext2;
  /**
   * 扩展字段3
   */
  private String subsidyext3;
  /**
   * 扩展字段4
   */
  private String subsidyext4;
  /**
   * 扩展字段5
   */
  private String subsidyext5;
  /**
   * 扩展字段6
   */
  private String subsidyext6;
  /**
   * 扩展字段7
   */
  private String subsidyext7;
  /**
   * 扩展字段8
   */
  private String subsidyext8;
  /**
   * 扩展字段9
   */
  private String subsidyext9;
  /**
   * 扩展字段10
   */
  private String subsidyext10;
  /**
   * 入账会计期间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime accountingPeriod;
  /**
   * 被冲账会计期间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime reversePeriod;
  /**
   * 金额
   */
  private BigDecimal amount;
  /**
   * 处理状态
   */
  private String status;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("subsidy_name", subsidyName);
      map.put("occurrence_period", BocpGenUtils.toTimestamp(occurrencePeriod));
      map.put("invoice_no", invoiceNo);
      map.put("invoice_project_name", invoiceProjectName);
      map.put("amount_with_tax", amountWithTax);
      map.put("tax_rate", taxRate);
      map.put("invoice_time", BocpGenUtils.toTimestamp(invoiceTime));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("store_id", storeId);
      map.put("store_name", storeName);
      map.put("account_name", accountName);
      map.put("order_no", orderNo);
      map.put("summary_date", BocpGenUtils.toTimestamp(summaryDate));
      map.put("closing_type", closingType);
      map.put("ebs_return", ebsReturn);
      map.put("document_no", documentNo);
      map.put("document_type", documentType);
      map.put("abnormal_info", abnormalInfo);
      map.put("subsidyext_1", subsidyext1);
      map.put("subsidyext_2", subsidyext2);
      map.put("subsidyext_3", subsidyext3);
      map.put("subsidyext_4", subsidyext4);
      map.put("subsidyext_5", subsidyext5);
      map.put("subsidyext_6", subsidyext6);
      map.put("subsidyext_7", subsidyext7);
      map.put("subsidyext_8", subsidyext8);
      map.put("subsidyext_9", subsidyext9);
      map.put("subsidyext_10", subsidyext10);
      map.put("accounting_period", BocpGenUtils.toTimestamp(accountingPeriod));
      map.put("reverse_period", BocpGenUtils.toTimestamp(reversePeriod));
      map.put("amount", amount);
      map.put("status", status);

      return map;
  }

  public static PlatformSubsidyInvoiceSettlement fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    PlatformSubsidyInvoiceSettlement entity = new PlatformSubsidyInvoiceSettlement();

    if(map.containsKey("subsidy_name")) {
      Object obj = map.get("subsidy_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSubsidyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("occurrence_period")) {
      Object obj = map.get("occurrence_period");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOccurrencePeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setOccurrencePeriod((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOccurrencePeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOccurrencePeriod(null);
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_project_name")) {
      Object obj = map.get("invoice_project_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_time")) {
      Object obj = map.get("invoice_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setInvoiceTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvoiceTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("store_id")) {
      Object obj = map.get("store_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("store_name")) {
      Object obj = map.get("store_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_name")) {
      Object obj = map.get("account_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("summary_date")) {
      Object obj = map.get("summary_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSummaryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSummaryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSummaryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSummaryDate(null);
      }
    }
    if(map.containsKey("closing_type")) {
      Object obj = map.get("closing_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setClosingType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ebs_return")) {
      Object obj = map.get("ebs_return");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEbsReturn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("document_no")) {
      Object obj = map.get("document_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("document_type")) {
      Object obj = map.get("document_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("abnormal_info")) {
      Object obj = map.get("abnormal_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAbnormalInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subsidyext_1")) {
      Object obj = map.get("subsidyext_1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSubsidyext1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subsidyext_2")) {
      Object obj = map.get("subsidyext_2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSubsidyext2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subsidyext_3")) {
      Object obj = map.get("subsidyext_3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSubsidyext3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subsidyext_4")) {
      Object obj = map.get("subsidyext_4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSubsidyext4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subsidyext_5")) {
      Object obj = map.get("subsidyext_5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSubsidyext5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subsidyext_6")) {
      Object obj = map.get("subsidyext_6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSubsidyext6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subsidyext_7")) {
      Object obj = map.get("subsidyext_7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSubsidyext7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subsidyext_8")) {
      Object obj = map.get("subsidyext_8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSubsidyext8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subsidyext_9")) {
      Object obj = map.get("subsidyext_9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSubsidyext9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subsidyext_10")) {
      Object obj = map.get("subsidyext_10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSubsidyext10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accounting_period")) {
      Object obj = map.get("accounting_period");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountingPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAccountingPeriod((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAccountingPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAccountingPeriod(null);
      }
    }
    if(map.containsKey("reverse_period")) {
      Object obj = map.get("reverse_period");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReversePeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReversePeriod((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReversePeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReversePeriod(null);
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("subsidy_name")) {
      Object obj = map.get("subsidy_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSubsidyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("occurrence_period")) {
      Object obj = map.get("occurrence_period");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setOccurrencePeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setOccurrencePeriod((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOccurrencePeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setOccurrencePeriod(null);
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_project_name")) {
      Object obj = map.get("invoice_project_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_time")) {
      Object obj = map.get("invoice_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setInvoiceTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setInvoiceTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setInvoiceTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setInvoiceTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("store_id")) {
      Object obj = map.get("store_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStoreId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("store_name")) {
      Object obj = map.get("store_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_name")) {
      Object obj = map.get("account_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAccountName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("summary_date")) {
      Object obj = map.get("summary_date");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSummaryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setSummaryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSummaryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setSummaryDate(null);
      }
    }
    if(map.containsKey("closing_type")) {
      Object obj = map.get("closing_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setClosingType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ebs_return")) {
      Object obj = map.get("ebs_return");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setEbsReturn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("document_no")) {
      Object obj = map.get("document_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDocumentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("document_type")) {
      Object obj = map.get("document_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDocumentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("abnormal_info")) {
      Object obj = map.get("abnormal_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAbnormalInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subsidyext_1")) {
      Object obj = map.get("subsidyext_1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSubsidyext1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subsidyext_2")) {
      Object obj = map.get("subsidyext_2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSubsidyext2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subsidyext_3")) {
      Object obj = map.get("subsidyext_3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSubsidyext3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subsidyext_4")) {
      Object obj = map.get("subsidyext_4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSubsidyext4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subsidyext_5")) {
      Object obj = map.get("subsidyext_5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSubsidyext5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subsidyext_6")) {
      Object obj = map.get("subsidyext_6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSubsidyext6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subsidyext_7")) {
      Object obj = map.get("subsidyext_7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSubsidyext7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subsidyext_8")) {
      Object obj = map.get("subsidyext_8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSubsidyext8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subsidyext_9")) {
      Object obj = map.get("subsidyext_9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSubsidyext9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subsidyext_10")) {
      Object obj = map.get("subsidyext_10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSubsidyext10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accounting_period")) {
      Object obj = map.get("accounting_period");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAccountingPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAccountingPeriod((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAccountingPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAccountingPeriod(null);
      }
    }
    if(map.containsKey("reverse_period")) {
      Object obj = map.get("reverse_period");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setReversePeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setReversePeriod((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setReversePeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setReversePeriod(null);
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStatus((String)obj);
        }
      } else{
      }
    }
  }
}
