package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_check_account_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-04
 */
public enum DyCheckAccountType {

    _1("1", "微信"),
    _2("2", "支付宝"),
    _3("3", "合众支付"),
    _4("4", "聚合支付");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DyCheckAccountType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyCheckAccountType fromCode(String code) {
        return Stream.of(DyCheckAccountType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
