package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * gift_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-04
 */
public enum GiftType {

    _1("1", "自产赠品"),
    _2("2", "外购赠品"),
    _3("3", "买赠主品");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    GiftType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static GiftType fromCode(String code) {
        return Stream.of(GiftType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
