package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * valid_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-04
 */
public enum ValidStatus {

    _0("0", "未作废"),
    _1("1", "已作废");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ValidStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ValidStatus fromCode(String code) {
        return Stream.of(ValidStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
