package com.xforceplus.ultraman.app.policymanagement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * write_off_result
 * </p>
 *
 * @author ultraman
 * @since 2024-12-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class WriteOffResult implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 对账结果业务主键
   */
  private String resultMd5;
  /**
   * 电商平台
   */
  private String ecChannel;
  /**
   * 电商平台店铺id
   */
  private String storeId;
  /**
   * 组织ID
   */
  private Long orgId;
  /**
   * 电商平台店铺名称
   */
  private String storeName;
  /**
   * 对账日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime checkTime;
  /**
   * 对账差异金额
   */
  private BigDecimal checkDiffAmount;
  /**
   * 对账状态
   */
  private String checkStatus;
  /**
   * 对账结果
   */
  private String checkResult;
  /**
   * 核销策略id
   */
  private String checkConfigId;
  /**
   * 应收业务类型（0：收；1：退）
   */
  private String receivableBusinessType;
  /**
   * 是否虚拟订单（0：否；1：是）
   */
  private String isVirtual;
  /**
   * 应收单中的销售订单号
   */
  private String orderNo;
  /**
   * 应收订单已核销金额
   */
  private BigDecimal receivableOrderWrittenOffAmount;
  /**
   * 应收订单未核销金额
   */
  private BigDecimal receivableOrderWritingOffAmount;
  /**
   * 资金账单已核销金额
   */
  private BigDecimal billWrittenOffAmount;
  /**
   * 资金账单未核销金额
   */
  private BigDecimal billWritingOffAmount;
  /**
   * 本次核销金额
   */
  private BigDecimal writeOffAmount;
  /**
   * 核销确认状态
   */
  private String writeOffConfirmStatus;
  /**
   * 核销确认日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime writeOffConfirmTime;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 组织树
   */
  private String orgTree;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 白药事务部
   */
  private String businessUnit;
  /**
   * 核销状态
   */
  private String writeOffStatus;
  /**
   * 白药公司
   */
  private String companyName;
  /**
   * 应收订单合计金额
   */
  private BigDecimal receivableOrderTotalAmount;
  /**
   * 资金账单合计金额
   */
  private BigDecimal billTotalAmount;
  /**
   * 错误信息
   */
  private String errorMsg;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("result_md5", resultMd5);
      map.put("ec_channel", ecChannel);
      map.put("store_id", storeId);
      map.put("org_id", orgId);
      map.put("store_name", storeName);
      map.put("check_time", BocpGenUtils.toTimestamp(checkTime));
      map.put("check_diff_amount", checkDiffAmount);
      map.put("check_status", checkStatus);
      map.put("check_result", checkResult);
      map.put("check_config_id", checkConfigId);
      map.put("receivable_business_type", receivableBusinessType);
      map.put("is_virtual", isVirtual);
      map.put("order_no", orderNo);
      map.put("receivable_order_written_off_amount", receivableOrderWrittenOffAmount);
      map.put("receivable_order_writing_off_amount", receivableOrderWritingOffAmount);
      map.put("bill_written_off_amount", billWrittenOffAmount);
      map.put("bill_writing_off_amount", billWritingOffAmount);
      map.put("write_off_amount", writeOffAmount);
      map.put("write_off_confirm_status", writeOffConfirmStatus);
      map.put("write_off_confirm_time", BocpGenUtils.toTimestamp(writeOffConfirmTime));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("business_unit", businessUnit);
      map.put("write_off_status", writeOffStatus);
      map.put("company_name", companyName);
      map.put("receivable_order_total_amount", receivableOrderTotalAmount);
      map.put("bill_total_amount", billTotalAmount);
      map.put("error_msg", errorMsg);

      return map;
  }

  public static WriteOffResult fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    WriteOffResult entity = new WriteOffResult();

    if(map.containsKey("result_md5")) {
      Object obj = map.get("result_md5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setResultMd5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ec_channel")) {
      Object obj = map.get("ec_channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEcChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("store_id")) {
      Object obj = map.get("store_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("store_name")) {
      Object obj = map.get("store_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_time")) {
      Object obj = map.get("check_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCheckTime(null);
      }
    }
    if(map.containsKey("check_diff_amount")) {
      Object obj = map.get("check_diff_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCheckDiffAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCheckDiffAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCheckDiffAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckDiffAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCheckDiffAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("check_status")) {
      Object obj = map.get("check_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_result")) {
      Object obj = map.get("check_result");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckResult((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_config_id")) {
      Object obj = map.get("check_config_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckConfigId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivable_business_type")) {
      Object obj = map.get("receivable_business_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceivableBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_virtual")) {
      Object obj = map.get("is_virtual");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsVirtual((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivable_order_written_off_amount")) {
      Object obj = map.get("receivable_order_written_off_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReceivableOrderWrittenOffAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReceivableOrderWrittenOffAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReceivableOrderWrittenOffAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceivableOrderWrittenOffAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReceivableOrderWrittenOffAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("receivable_order_writing_off_amount")) {
      Object obj = map.get("receivable_order_writing_off_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReceivableOrderWritingOffAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReceivableOrderWritingOffAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReceivableOrderWritingOffAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceivableOrderWritingOffAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReceivableOrderWritingOffAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bill_written_off_amount")) {
      Object obj = map.get("bill_written_off_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBillWrittenOffAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBillWrittenOffAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBillWrittenOffAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillWrittenOffAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBillWrittenOffAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bill_writing_off_amount")) {
      Object obj = map.get("bill_writing_off_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBillWritingOffAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBillWritingOffAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBillWritingOffAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillWritingOffAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBillWritingOffAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("write_off_amount")) {
      Object obj = map.get("write_off_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setWriteOffAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setWriteOffAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setWriteOffAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setWriteOffAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setWriteOffAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("write_off_confirm_status")) {
      Object obj = map.get("write_off_confirm_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWriteOffConfirmStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("write_off_confirm_time")) {
      Object obj = map.get("write_off_confirm_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setWriteOffConfirmTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setWriteOffConfirmTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setWriteOffConfirmTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setWriteOffConfirmTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_unit")) {
      Object obj = map.get("business_unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("write_off_status")) {
      Object obj = map.get("write_off_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWriteOffStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivable_order_total_amount")) {
      Object obj = map.get("receivable_order_total_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReceivableOrderTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReceivableOrderTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReceivableOrderTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceivableOrderTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReceivableOrderTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bill_total_amount")) {
      Object obj = map.get("bill_total_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBillTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBillTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBillTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBillTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorMsg((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("result_md5")) {
      Object obj = map.get("result_md5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setResultMd5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ec_channel")) {
      Object obj = map.get("ec_channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setEcChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("store_id")) {
      Object obj = map.get("store_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStoreId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setOrgId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("store_name")) {
      Object obj = map.get("store_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_time")) {
      Object obj = map.get("check_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCheckTime(null);
      }
    }
    if(map.containsKey("check_diff_amount")) {
      Object obj = map.get("check_diff_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setCheckDiffAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setCheckDiffAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setCheckDiffAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCheckDiffAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setCheckDiffAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("check_status")) {
      Object obj = map.get("check_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_result")) {
      Object obj = map.get("check_result");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckResult((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_config_id")) {
      Object obj = map.get("check_config_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckConfigId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivable_business_type")) {
      Object obj = map.get("receivable_business_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReceivableBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_virtual")) {
      Object obj = map.get("is_virtual");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsVirtual((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivable_order_written_off_amount")) {
      Object obj = map.get("receivable_order_written_off_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setReceivableOrderWrittenOffAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setReceivableOrderWrittenOffAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setReceivableOrderWrittenOffAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setReceivableOrderWrittenOffAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setReceivableOrderWrittenOffAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("receivable_order_writing_off_amount")) {
      Object obj = map.get("receivable_order_writing_off_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setReceivableOrderWritingOffAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setReceivableOrderWritingOffAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setReceivableOrderWritingOffAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setReceivableOrderWritingOffAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setReceivableOrderWritingOffAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bill_written_off_amount")) {
      Object obj = map.get("bill_written_off_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setBillWrittenOffAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setBillWrittenOffAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setBillWrittenOffAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBillWrittenOffAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setBillWrittenOffAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bill_writing_off_amount")) {
      Object obj = map.get("bill_writing_off_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setBillWritingOffAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setBillWritingOffAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setBillWritingOffAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBillWritingOffAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setBillWritingOffAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("write_off_amount")) {
      Object obj = map.get("write_off_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setWriteOffAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setWriteOffAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setWriteOffAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setWriteOffAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setWriteOffAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("write_off_confirm_status")) {
      Object obj = map.get("write_off_confirm_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setWriteOffConfirmStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("write_off_confirm_time")) {
      Object obj = map.get("write_off_confirm_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setWriteOffConfirmTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setWriteOffConfirmTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setWriteOffConfirmTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setWriteOffConfirmTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_unit")) {
      Object obj = map.get("business_unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusinessUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("write_off_status")) {
      Object obj = map.get("write_off_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setWriteOffStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivable_order_total_amount")) {
      Object obj = map.get("receivable_order_total_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setReceivableOrderTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setReceivableOrderTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setReceivableOrderTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setReceivableOrderTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setReceivableOrderTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bill_total_amount")) {
      Object obj = map.get("bill_total_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setBillTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setBillTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setBillTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBillTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setBillTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setErrorMsg((String)obj);
        }
      } else{
      }
    }
  }
}
