package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * bill_change_record_source
 * </p>
 *
 * @author ultraman
 * @since 2024-12-05
 */
public enum BillChangeRecordSource {

    S_PDD("S-PDD", "拼多多销售订单"),
    A_PDD("A-PDD", "拼多多售后"),
    S_TM("S-TM", "天猫销售订单"),
    A_TM("A-TM", "天猫售后"),
    S_KS("S-KS", "快手销售订单"),
    A_KS("A-KS", "快手售后"),
    S_DY("S-DY", "抖音销售订单"),
    A_DY("A-DY", "抖音销售订单"),
    S_JD("S-JD", "京东-销售"),
    A_JD("A-JD", "京东-售后"),
    S_WDGJ("S-WDGJ", "网点管家销售"),
    A_WDGJ("A-WDGJ", "网点管家售后"),
    DEFAULT("default", "默认");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillChangeRecordSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillChangeRecordSource fromCode(String code) {
        return Stream.of(BillChangeRecordSource.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
