package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_order_types
 * </p>
 *
 * @author ultraman
 * @since 2024-12-05
 */
public enum DyOrderTypes {

    _0("0", "普通订单"),
    _2("2", "虚拟商品订单"),
    _4("4", "电子券（poi核销）"),
    _5("5", "三方核销"),
    _1("1", "-"),
    _3("3", "-"),
    _6("6", "-");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DyOrderTypes(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyOrderTypes fromCode(String code) {
        return Stream.of(DyOrderTypes.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
