package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_refund_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-05
 */
public enum DyRefundType {

    _1("1", "极速退款助手"),
    _2("2", "售后小助手"),
    _3("3", "售后极速退"),
    _4("4", "闪电退货"),
    _0("0", "--");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DyRefundType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyRefundType fromCode(String code) {
        return Stream.of(DyRefundType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
