package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ebs_back_stauts
 * </p>
 *
 * @author ultraman
 * @since 2024-12-05
 */
public enum EbsBackStauts {

    _1("1", "待回传"),
    _2("2", "回传中"),
    _3("3", "已回传");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    EbsBackStauts(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EbsBackStauts fromCode(String code) {
        return Stream.of(EbsBackStauts.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
