package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * income_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-05
 */
public enum IncomeType {

    R("R", "收入"),
    E("E", "费用"),
    O("O", "其他"),
    A("A", "退货退款"),
    CL("CL", "合同负债"),
    RO("RO", "仅退款"),
    CO("CO", "提现");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IncomeType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IncomeType fromCode(String code) {
        return Stream.of(IncomeType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
