package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ks_check_in_out_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-05
 */
public enum KsCheckInOutType {

    _1("1", "收"),
    _2("2", "支");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    KsCheckInOutType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static KsCheckInOutType fromCode(String code) {
        return Stream.of(KsCheckInOutType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
