package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ksnegotiate_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-05
 */
public enum KsnegotiateStatus {

    _0("0", "未知状态"),
    _1("1", "待商家处理"),
    _2("2", "商家同意"),
    _3("3", "商家驳回，等待买家修改");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    KsnegotiateStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static KsnegotiateStatus fromCode(String code) {
        return Stream.of(KsnegotiateStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
