package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * oms_trade_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-05
 */
public enum OmsTradeStatus {

    _8("8", "发货在途"),
    _11("11", "已完成"),
    _0("0", "被取消"),
    _1("1", "等待单"),
    _2("2", "待审核"),
    _3("3", "预订单"),
    _4("4", "待结算"),
    _5("5", "打单出库"),
    _6("6", "生产等待"),
    _7("7", " 待发货"),
    _9("9", "代销发货"),
    _10("10", "委外发货"),
    _12("12", "12"),
    _13("13", "13"),
    _14("14", "14"),
    _15("15", "15"),
    _16("16", "16"),
    _17("17", "17"),
    _18("18", "18"),
    __1("-1", "未对接");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OmsTradeStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OmsTradeStatus fromCode(String code) {
        return Stream.of(OmsTradeStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
