package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pdd_refund_operator_role
 * </p>
 *
 * @author ultraman
 * @since 2024-12-05
 */
public enum PddRefundOperatorRole {

    _0("0", "默认"),
    _1("1", "用户"),
    _2("2", "商家"),
    _3("3", "平台"),
    _4("4", "系统"),
    _5("5", "团长"),
    _6("6", "司机"),
    _7("7", "代理人");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PddRefundOperatorRole(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PddRefundOperatorRole fromCode(String code) {
        return Stream.of(PddRefundOperatorRole.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
