package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pdd_user_shipping_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-05
 */
public enum PddUserShippingStatus {

    _0("0", "未勾选"),
    _1("1", "消费者选择的收货状态为未收到货"),
    _2("2", "消费者选择的收货状态为已收到货");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PddUserShippingStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PddUserShippingStatus fromCode(String code) {
        return Stream.of(PddUserShippingStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
