package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * positive_negative
 * </p>
 *
 * @author ultraman
 * @since 2024-12-05
 */
public enum PositiveNegative {

    _1("1", "正数"),
    _2("2", "负数");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PositiveNegative(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PositiveNegative fromCode(String code) {
        return Stream.of(PositiveNegative.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
