package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * receivable_order_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-05
 */
public enum ReceivableOrderType {

    _1("1", "调整单"),
    _0("0", "应收单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ReceivableOrderType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReceivableOrderType fromCode(String code) {
        return Stream.of(ReceivableOrderType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
