package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * sale_return_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-05
 */
public enum SaleReturnStatus {

    _0("0", "销售"),
    _1("1", "售后"),
    __1("-1", "--");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SaleReturnStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SaleReturnStatus fromCode(String code) {
        return Stream.of(SaleReturnStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
