package com.xforceplus.ultraman.app.policymanagement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * oms_after_sale
 * </p>
 *
 * @author ultraman
 * @since 2024-12-05
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OmsAfterSale implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 主键
   */
  private Long omsId;
  /**
   * 退换单ID
   */
  private String tradeId;
  /**
   * 退换单号
   */
  private String tradeNo;
  /**
   * 原始单号
   */
  private String rawNo;
  /**
   * 管家原关联订单号
   */
  private String oldNo;
  /**
   * 换货管家关联订单号
   */
  private String newNo;
  /**
   * 退换单状态
   */
  private String tradeStatus;
  /**
   * 原店铺名
   */
  private String shopName;
  /**
   * 原店铺编号
   */
  private String shopNo;
  /**
   * 换货店铺名
   */
  private String shopName2;
  /**
   * 结算时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime chargeTime;
  /**
   * 登记时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime regTime;
  /**
   * 收货时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime rcvTime;
  /**
   * 业务员
   */
  private String seller;
  /**
   * 原订单类型
   */
  private String tradeType;
  /**
   * 退货仓库id
   */
  private String wareHouseId;
  /**
   * 退货仓库编号
   */
  private String wareHouseNo;
  /**
   * 退货仓库名
   */
  private String wareHouseName;
  /**
   * 换货仓库id
   */
  private String wareHouseId2;
  /**
   * 换货仓库编号
   */
  private String wareHouseNo2;
  /**
   * 换货仓库名
   */
  private String wareHouseName2;
  /**
   * 物流id
   */
  private String logisticId;
  /**
   * 物流编号
   */
  private String logisticNo;
  /**
   * 物流名
   */
  private String logisticName;
  /**
   * 快递单号
   */
  private String postId;
  /**
   * 应收邮资
   */
  private BigDecimal postageTotal;
  /**
   * 换货金额
   */
  private BigDecimal totalRcv;
  /**
   * 退货金额
   */
  private BigDecimal totalPay;
  /**
   * 应退合计
   */
  private BigDecimal returnTotal;
  /**
   * 结算金额
   */
  private BigDecimal recvTotal;
  /**
   * 取消原因
   */
  private String reason;
  /**
   * 卖家备注
   */
  private String remark;
  /**
   * 会员id
   */
  private String customerId;
  /**
   * 原店铺类别
   */
  private String shopType;
  /**
   * 换货店铺类别
   */
  private String shopType2;
  /**
   * 邮编
   */
  private String zip;
  /**
   * 类型
   */
  private String returnType;
  /**
   * 退换单关联入库单号
   */
  private String stockInNo;
  /**
   * 换货店铺编号
   */
  private String shopNo2;
  /**
   * 国家
   */
  private String country;
  /**
   * 省
   */
  private String province;
  /**
   * 市
   */
  private String city;
  /**
   * 区县
   */
  private String town;
  /**
   * 退货优惠
   */
  private BigDecimal returnsPreferential;
  /**
   * 换货优惠
   */
  private BigDecimal exchangePreferential;
  /**
   * 订单优惠
   */
  private BigDecimal orderPreferential;
  /**
   * 网名
   */
  private String nickName;
  /**
   * 收件人
   */
  private String sndTo;
  /**
   * 地址
   */
  private String adr;
  /**
   * 原订单的地址
   */
  private String orderAdr;
  /**
   * 电话
   */
  private String tel;
  /**
   * 系统创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime omsCreateTime;
  /**
   * 系统更新时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime omsUpdateTime;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 组织树
   */
  private String orgTree;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 单据流转处理状态
   */
  private String dealStatus;
  /**
   * 业务ID
   */
  private String businessId;
  /**
   * 对账状态
   */
  private String checkStatus;
  /**
   * 数据MD5
   */
  private String dataMD5;
  /**
   * 异常信息
   */
  private String errorMsg;
  /**
   * 最新版本
   */
  private Boolean latest;
  /**
   * 对账金额
   */
  private BigDecimal checkAmount;
  /**
   * 电商渠道
   */
  private String ecChannel;
  /**
   * 事业部名称
   */
  private String bussinessUnitName;
  /**
   * 公司名称
   */
  private String companyName;
  /**
   * 公司税号
   */
  private String companyTaxNo;
  /**
   * 获取日期
   */
  private String acqDate;
  /**
   * 店铺编号
   */
  private String shopId;
  /**
   * oms店铺ID
   */
  private String omsShopId;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("oms_id", omsId);
      map.put("trade_id", tradeId);
      map.put("trade_no", tradeNo);
      map.put("raw_no", rawNo);
      map.put("old_no", oldNo);
      map.put("new_no", newNo);
      map.put("trade_status", tradeStatus);
      map.put("shop_name", shopName);
      map.put("shop_no", shopNo);
      map.put("shop_name2", shopName2);
      map.put("charge_time", BocpGenUtils.toTimestamp(chargeTime));
      map.put("reg_time", BocpGenUtils.toTimestamp(regTime));
      map.put("rcv_time", BocpGenUtils.toTimestamp(rcvTime));
      map.put("seller", seller);
      map.put("trade_type", tradeType);
      map.put("ware_house_id", wareHouseId);
      map.put("ware_house_no", wareHouseNo);
      map.put("ware_house_name", wareHouseName);
      map.put("ware_house_id2", wareHouseId2);
      map.put("ware_house_no2", wareHouseNo2);
      map.put("ware_house_name2", wareHouseName2);
      map.put("logistic_id", logisticId);
      map.put("logistic_no", logisticNo);
      map.put("logistic_name", logisticName);
      map.put("post_id", postId);
      map.put("postage_total", postageTotal);
      map.put("total_rcv", totalRcv);
      map.put("total_pay", totalPay);
      map.put("return_total", returnTotal);
      map.put("recv_total", recvTotal);
      map.put("reason", reason);
      map.put("remark", remark);
      map.put("customer_id", customerId);
      map.put("shop_type", shopType);
      map.put("shop_type2", shopType2);
      map.put("zip", zip);
      map.put("return_type", returnType);
      map.put("stock_in_no", stockInNo);
      map.put("shop_no2", shopNo2);
      map.put("country", country);
      map.put("province", province);
      map.put("city", city);
      map.put("town", town);
      map.put("returns_preferential", returnsPreferential);
      map.put("exchange_preferential", exchangePreferential);
      map.put("order_preferential", orderPreferential);
      map.put("nick_name", nickName);
      map.put("snd_to", sndTo);
      map.put("adr", adr);
      map.put("order_adr", orderAdr);
      map.put("tel", tel);
      map.put("oms_create_time", BocpGenUtils.toTimestamp(omsCreateTime));
      map.put("oms_update_time", BocpGenUtils.toTimestamp(omsUpdateTime));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("deal_status", dealStatus);
      map.put("business_id", businessId);
      map.put("checkStatus", checkStatus);
      map.put("dataMD5", dataMD5);
      map.put("error_msg", errorMsg);
      map.put("latest", latest);
      map.put("check_amount", checkAmount);
      map.put("ec_channel", ecChannel);
      map.put("bussiness_unit_name", bussinessUnitName);
      map.put("company_name", companyName);
      map.put("company_tax_no", companyTaxNo);
      map.put("acq_date", acqDate);
      map.put("shop_id", shopId);
      map.put("oms_shop_id", omsShopId);

      return map;
  }

  public static OmsAfterSale fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    OmsAfterSale entity = new OmsAfterSale();

    if(map.containsKey("oms_id")) {
      Object obj = map.get("oms_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOmsId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOmsId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOmsId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("trade_id")) {
      Object obj = map.get("trade_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTradeId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trade_no")) {
      Object obj = map.get("trade_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTradeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("raw_no")) {
      Object obj = map.get("raw_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRawNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("old_no")) {
      Object obj = map.get("old_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOldNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("new_no")) {
      Object obj = map.get("new_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNewNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trade_status")) {
      Object obj = map.get("trade_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTradeStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_name")) {
      Object obj = map.get("shop_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_no")) {
      Object obj = map.get("shop_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_name2")) {
      Object obj = map.get("shop_name2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopName2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_time")) {
      Object obj = map.get("charge_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setChargeTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setChargeTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setChargeTime(null);
      }
    }
    if(map.containsKey("reg_time")) {
      Object obj = map.get("reg_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRegTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setRegTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRegTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRegTime(null);
      }
    }
    if(map.containsKey("rcv_time")) {
      Object obj = map.get("rcv_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRcvTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setRcvTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRcvTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRcvTime(null);
      }
    }
    if(map.containsKey("seller")) {
      Object obj = map.get("seller");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSeller((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trade_type")) {
      Object obj = map.get("trade_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTradeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ware_house_id")) {
      Object obj = map.get("ware_house_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWareHouseId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ware_house_no")) {
      Object obj = map.get("ware_house_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWareHouseNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ware_house_name")) {
      Object obj = map.get("ware_house_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWareHouseName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ware_house_id2")) {
      Object obj = map.get("ware_house_id2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWareHouseId2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ware_house_no2")) {
      Object obj = map.get("ware_house_no2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWareHouseNo2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ware_house_name2")) {
      Object obj = map.get("ware_house_name2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWareHouseName2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logistic_id")) {
      Object obj = map.get("logistic_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logistic_no")) {
      Object obj = map.get("logistic_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logistic_name")) {
      Object obj = map.get("logistic_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("post_id")) {
      Object obj = map.get("post_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPostId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("postage_total")) {
      Object obj = map.get("postage_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPostageTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPostageTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPostageTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPostageTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPostageTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total_rcv")) {
      Object obj = map.get("total_rcv");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalRcv((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalRcv(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalRcv(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalRcv(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalRcv(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total_pay")) {
      Object obj = map.get("total_pay");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalPay((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalPay(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalPay(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalPay(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalPay(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("return_total")) {
      Object obj = map.get("return_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReturnTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReturnTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReturnTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReturnTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReturnTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("recv_total")) {
      Object obj = map.get("recv_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRecvTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRecvTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRecvTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRecvTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRecvTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("reason")) {
      Object obj = map.get("reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_id")) {
      Object obj = map.get("customer_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_type")) {
      Object obj = map.get("shop_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_type2")) {
      Object obj = map.get("shop_type2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopType2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zip")) {
      Object obj = map.get("zip");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZip((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("return_type")) {
      Object obj = map.get("return_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stock_in_no")) {
      Object obj = map.get("stock_in_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStockInNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_no2")) {
      Object obj = map.get("shop_no2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopNo2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("country")) {
      Object obj = map.get("country");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCountry((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("province")) {
      Object obj = map.get("province");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProvince((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("city")) {
      Object obj = map.get("city");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("town")) {
      Object obj = map.get("town");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTown((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("returns_preferential")) {
      Object obj = map.get("returns_preferential");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReturnsPreferential((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReturnsPreferential(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReturnsPreferential(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReturnsPreferential(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReturnsPreferential(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("exchange_preferential")) {
      Object obj = map.get("exchange_preferential");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExchangePreferential((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExchangePreferential(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExchangePreferential(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExchangePreferential(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExchangePreferential(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("order_preferential")) {
      Object obj = map.get("order_preferential");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderPreferential((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderPreferential(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderPreferential(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderPreferential(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderPreferential(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("nick_name")) {
      Object obj = map.get("nick_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNickName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("snd_to")) {
      Object obj = map.get("snd_to");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSndTo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("adr")) {
      Object obj = map.get("adr");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAdr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_adr")) {
      Object obj = map.get("order_adr");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderAdr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tel")) {
      Object obj = map.get("tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oms_create_time")) {
      Object obj = map.get("oms_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOmsCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setOmsCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOmsCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOmsCreateTime(null);
      }
    }
    if(map.containsKey("oms_update_time")) {
      Object obj = map.get("oms_update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOmsUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setOmsUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOmsUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOmsUpdateTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDealStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("check_amount")) {
      Object obj = map.get("check_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCheckAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCheckAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCheckAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCheckAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ec_channel")) {
      Object obj = map.get("ec_channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEcChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bussiness_unit_name")) {
      Object obj = map.get("bussiness_unit_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBussinessUnitName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_tax_no")) {
      Object obj = map.get("company_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("acq_date")) {
      Object obj = map.get("acq_date");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAcqDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oms_shop_id")) {
      Object obj = map.get("oms_shop_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOmsShopId((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("oms_id")) {
      Object obj = map.get("oms_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setOmsId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOmsId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setOmsId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("trade_id")) {
      Object obj = map.get("trade_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTradeId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trade_no")) {
      Object obj = map.get("trade_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTradeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("raw_no")) {
      Object obj = map.get("raw_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRawNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("old_no")) {
      Object obj = map.get("old_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOldNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("new_no")) {
      Object obj = map.get("new_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNewNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trade_status")) {
      Object obj = map.get("trade_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTradeStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_name")) {
      Object obj = map.get("shop_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setShopName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_no")) {
      Object obj = map.get("shop_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setShopNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_name2")) {
      Object obj = map.get("shop_name2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setShopName2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_time")) {
      Object obj = map.get("charge_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setChargeTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setChargeTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setChargeTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setChargeTime(null);
      }
    }
    if(map.containsKey("reg_time")) {
      Object obj = map.get("reg_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRegTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setRegTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRegTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setRegTime(null);
      }
    }
    if(map.containsKey("rcv_time")) {
      Object obj = map.get("rcv_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRcvTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setRcvTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRcvTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setRcvTime(null);
      }
    }
    if(map.containsKey("seller")) {
      Object obj = map.get("seller");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSeller((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trade_type")) {
      Object obj = map.get("trade_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTradeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ware_house_id")) {
      Object obj = map.get("ware_house_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setWareHouseId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ware_house_no")) {
      Object obj = map.get("ware_house_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setWareHouseNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ware_house_name")) {
      Object obj = map.get("ware_house_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setWareHouseName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ware_house_id2")) {
      Object obj = map.get("ware_house_id2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setWareHouseId2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ware_house_no2")) {
      Object obj = map.get("ware_house_no2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setWareHouseNo2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ware_house_name2")) {
      Object obj = map.get("ware_house_name2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setWareHouseName2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logistic_id")) {
      Object obj = map.get("logistic_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLogisticId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logistic_no")) {
      Object obj = map.get("logistic_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLogisticNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logistic_name")) {
      Object obj = map.get("logistic_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLogisticName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("post_id")) {
      Object obj = map.get("post_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPostId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("postage_total")) {
      Object obj = map.get("postage_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPostageTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPostageTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPostageTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPostageTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPostageTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total_rcv")) {
      Object obj = map.get("total_rcv");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTotalRcv((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTotalRcv(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTotalRcv(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTotalRcv(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTotalRcv(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total_pay")) {
      Object obj = map.get("total_pay");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTotalPay((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTotalPay(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTotalPay(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTotalPay(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTotalPay(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("return_total")) {
      Object obj = map.get("return_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setReturnTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setReturnTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setReturnTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setReturnTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setReturnTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("recv_total")) {
      Object obj = map.get("recv_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setRecvTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setRecvTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setRecvTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRecvTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setRecvTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("reason")) {
      Object obj = map.get("reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_id")) {
      Object obj = map.get("customer_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCustomerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_type")) {
      Object obj = map.get("shop_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setShopType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_type2")) {
      Object obj = map.get("shop_type2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setShopType2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zip")) {
      Object obj = map.get("zip");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setZip((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("return_type")) {
      Object obj = map.get("return_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReturnType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stock_in_no")) {
      Object obj = map.get("stock_in_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStockInNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_no2")) {
      Object obj = map.get("shop_no2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setShopNo2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("country")) {
      Object obj = map.get("country");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCountry((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("province")) {
      Object obj = map.get("province");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProvince((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("city")) {
      Object obj = map.get("city");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("town")) {
      Object obj = map.get("town");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTown((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("returns_preferential")) {
      Object obj = map.get("returns_preferential");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setReturnsPreferential((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setReturnsPreferential(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setReturnsPreferential(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setReturnsPreferential(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setReturnsPreferential(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("exchange_preferential")) {
      Object obj = map.get("exchange_preferential");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setExchangePreferential((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setExchangePreferential(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setExchangePreferential(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setExchangePreferential(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setExchangePreferential(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("order_preferential")) {
      Object obj = map.get("order_preferential");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setOrderPreferential((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setOrderPreferential(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setOrderPreferential(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOrderPreferential(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setOrderPreferential(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("nick_name")) {
      Object obj = map.get("nick_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNickName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("snd_to")) {
      Object obj = map.get("snd_to");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSndTo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("adr")) {
      Object obj = map.get("adr");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAdr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_adr")) {
      Object obj = map.get("order_adr");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrderAdr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tel")) {
      Object obj = map.get("tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oms_create_time")) {
      Object obj = map.get("oms_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setOmsCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setOmsCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOmsCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setOmsCreateTime(null);
      }
    }
    if(map.containsKey("oms_update_time")) {
      Object obj = map.get("oms_update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setOmsUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setOmsUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOmsUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setOmsUpdateTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDealStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDataMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setErrorMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("check_amount")) {
      Object obj = map.get("check_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setCheckAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setCheckAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setCheckAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCheckAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setCheckAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ec_channel")) {
      Object obj = map.get("ec_channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setEcChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bussiness_unit_name")) {
      Object obj = map.get("bussiness_unit_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBussinessUnitName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_tax_no")) {
      Object obj = map.get("company_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("acq_date")) {
      Object obj = map.get("acq_date");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAcqDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setShopId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oms_shop_id")) {
      Object obj = map.get("oms_shop_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOmsShopId((String)obj);
        }
      } else{
      }
    }
  }
}
