package com.xforceplus.ultraman.app.policymanagement.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * tb_sales_order_detail
 * </p>
 *
 * @author ultraman
 * @since 2024-12-05
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TbSalesOrderDetail implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * id
   */
  private Long tbId;
  /**
   * 租户code
   */
  private String tbTenantCode;
  /**
   * 店铺id
   */
  private String storeId;
  /**
   * 获取账单日期
   */
  private String acqBillDate;
  /**
   * 子订单编号
   */
  private String subOrderNo;
  /**
   * 主订单编号
   */
  private String orderNo;
  /**
   * 商品标题
   */
  private String goodsTitle;
  /**
   * 商品价格
   */
  private BigDecimal goodsPrice;
  /**
   * 购买数量
   */
  private Long buyCount;
  /**
   * 外部系统编号
   */
  private String extSysNo;
  /**
   * 商品属性
   */
  private String goodsAttr;
  /**
   * 套餐信息
   */
  private String packageInfo;
  /**
   * 联系方式备注
   */
  private String contactRemark;
  /**
   * 订单状态
   */
  private String orderStatus;
  /**
   * 商家编码
   */
  private String merchantCode;
  /**
   * 支付单号
   */
  private String payOrderNo;
  /**
   * 买家应付货款
   */
  private BigDecimal buyerPayable;
  /**
   * 买家实付金额
   */
  private BigDecimal buyerRealPay;
  /**
   * 退款状态
   */
  private String refundStatus;
  /**
   * 退款金额
   */
  private String refundAmount;
  /**
   * 订单创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime orderCreateTime;
  /**
   * 订单付款时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime orderPayTime;
  /**
   * 淘鲜达渠道
   */
  private String taoxdChannel;
  /**
   * 商品ID
   */
  private String goodsId;
  /**
   * 分阶段信息
   */
  private String phaseInfo;
  /**
   * 备注标签
   */
  private String remarkTag;
  /**
   * 商家备注
   */
  private String merchantRemark;
  /**
   * 买家留言
   */
  private String buyerMessage;
  /**
   * 应发货时间
   */
  private String deliveryTime;
  /**
   * 物流单号
   */
  private String logisticsNo;
  /**
   * 物流公司
   */
  private String logisticsCompany;
  /**
   * 是否主动赔付
   */
  private String activeCompensation;
  /**
   * 主动赔付金额
   */
  private String activeCompensationAmount;
  /**
   * 主动赔付出账时间
   */
  private String activeCompensationTime;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtCreate;
  /**
   * 更新时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtModified;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 对一关联关系 关联对象 tbSalesOrder
   */
  private Long mainId;

  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("tb_id", tbId);
      map.put("tb_tenant_code", tbTenantCode);
      map.put("store_id", storeId);
      map.put("acq_bill_date", acqBillDate);
      map.put("sub_order_no", subOrderNo);
      map.put("order_no", orderNo);
      map.put("goods_title", goodsTitle);
      map.put("goods_price", goodsPrice);
      map.put("buy_count", buyCount);
      map.put("ext_sys_no", extSysNo);
      map.put("goods_attr", goodsAttr);
      map.put("package_info", packageInfo);
      map.put("contact_remark", contactRemark);
      map.put("order_status", orderStatus);
      map.put("merchant_code", merchantCode);
      map.put("pay_order_no", payOrderNo);
      map.put("buyer_payable", buyerPayable);
      map.put("buyer_real_pay", buyerRealPay);
      map.put("refund_status", refundStatus);
      map.put("refund_amount", refundAmount);
      map.put("order_create_time", BocpGenUtils.toTimestamp(orderCreateTime));
      map.put("order_pay_time", BocpGenUtils.toTimestamp(orderPayTime));
      map.put("taoxd_channel", taoxdChannel);
      map.put("goods_id", goodsId);
      map.put("phase_info", phaseInfo);
      map.put("remark_tag", remarkTag);
      map.put("merchant_remark", merchantRemark);
      map.put("buyer_message", buyerMessage);
      map.put("delivery_time", deliveryTime);
      map.put("logistics_no", logisticsNo);
      map.put("logistics_company", logisticsCompany);
      map.put("active_compensation", activeCompensation);
      map.put("active_compensation_amount", activeCompensationAmount);
      map.put("active_compensation_time", activeCompensationTime);
      map.put("gmt_create", BocpGenUtils.toTimestamp(gmtCreate));
      map.put("gmt_modified", BocpGenUtils.toTimestamp(gmtModified));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("org_tree", orgTree);

      map.put("main.id", mainId);
      return map;
  }

  public static TbSalesOrderDetail fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    TbSalesOrderDetail entity = new TbSalesOrderDetail();

    if(map.containsKey("tb_id")) {
      Object obj = map.get("tb_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTbId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTbId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTbId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tb_tenant_code")) {
      Object obj = map.get("tb_tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTbTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("store_id")) {
      Object obj = map.get("store_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("acq_bill_date")) {
      Object obj = map.get("acq_bill_date");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAcqBillDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sub_order_no")) {
      Object obj = map.get("sub_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSubOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_title")) {
      Object obj = map.get("goods_title");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_price")) {
      Object obj = map.get("goods_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setGoodsPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setGoodsPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setGoodsPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGoodsPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGoodsPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("buy_count")) {
      Object obj = map.get("buy_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBuyCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBuyCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBuyCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ext_sys_no")) {
      Object obj = map.get("ext_sys_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtSysNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_attr")) {
      Object obj = map.get("goods_attr");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsAttr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("package_info")) {
      Object obj = map.get("package_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPackageInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contact_remark")) {
      Object obj = map.get("contact_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContactRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_status")) {
      Object obj = map.get("order_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("merchant_code")) {
      Object obj = map.get("merchant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMerchantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_order_no")) {
      Object obj = map.get("pay_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_payable")) {
      Object obj = map.get("buyer_payable");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBuyerPayable((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBuyerPayable(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBuyerPayable(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBuyerPayable(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBuyerPayable(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("buyer_real_pay")) {
      Object obj = map.get("buyer_real_pay");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBuyerRealPay((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBuyerRealPay(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBuyerRealPay(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBuyerRealPay(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBuyerRealPay(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("refund_status")) {
      Object obj = map.get("refund_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefundStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refund_amount")) {
      Object obj = map.get("refund_amount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefundAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_create_time")) {
      Object obj = map.get("order_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setOrderCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOrderCreateTime(null);
      }
    }
    if(map.containsKey("order_pay_time")) {
      Object obj = map.get("order_pay_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderPayTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setOrderPayTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderPayTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOrderPayTime(null);
      }
    }
    if(map.containsKey("taoxd_channel")) {
      Object obj = map.get("taoxd_channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaoxdChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_id")) {
      Object obj = map.get("goods_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("phase_info")) {
      Object obj = map.get("phase_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPhaseInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark_tag")) {
      Object obj = map.get("remark_tag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemarkTag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("merchant_remark")) {
      Object obj = map.get("merchant_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMerchantRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_message")) {
      Object obj = map.get("buyer_message");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerMessage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delivery_time")) {
      Object obj = map.get("delivery_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliveryTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logistics_no")) {
      Object obj = map.get("logistics_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticsNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logistics_company")) {
      Object obj = map.get("logistics_company");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticsCompany((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("active_compensation")) {
      Object obj = map.get("active_compensation");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setActiveCompensation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("active_compensation_amount")) {
      Object obj = map.get("active_compensation_amount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setActiveCompensationAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("active_compensation_time")) {
      Object obj = map.get("active_compensation_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setActiveCompensationTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtModified(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("main.id")) {
       Object obj = map.get("main.id");
       if(obj instanceof Long) {
         entity.setMainId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setMainId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("tb_id")) {
      Object obj = map.get("tb_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTbId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTbId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTbId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tb_tenant_code")) {
      Object obj = map.get("tb_tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTbTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("store_id")) {
      Object obj = map.get("store_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStoreId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("acq_bill_date")) {
      Object obj = map.get("acq_bill_date");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAcqBillDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sub_order_no")) {
      Object obj = map.get("sub_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSubOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_title")) {
      Object obj = map.get("goods_title");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGoodsTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_price")) {
      Object obj = map.get("goods_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setGoodsPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setGoodsPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setGoodsPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGoodsPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setGoodsPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("buy_count")) {
      Object obj = map.get("buy_count");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setBuyCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBuyCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setBuyCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ext_sys_no")) {
      Object obj = map.get("ext_sys_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtSysNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_attr")) {
      Object obj = map.get("goods_attr");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGoodsAttr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("package_info")) {
      Object obj = map.get("package_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPackageInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contact_remark")) {
      Object obj = map.get("contact_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setContactRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_status")) {
      Object obj = map.get("order_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("merchant_code")) {
      Object obj = map.get("merchant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMerchantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_order_no")) {
      Object obj = map.get("pay_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPayOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_payable")) {
      Object obj = map.get("buyer_payable");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setBuyerPayable((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setBuyerPayable(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setBuyerPayable(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBuyerPayable(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setBuyerPayable(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("buyer_real_pay")) {
      Object obj = map.get("buyer_real_pay");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setBuyerRealPay((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setBuyerRealPay(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setBuyerRealPay(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBuyerRealPay(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setBuyerRealPay(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("refund_status")) {
      Object obj = map.get("refund_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRefundStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refund_amount")) {
      Object obj = map.get("refund_amount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRefundAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_create_time")) {
      Object obj = map.get("order_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setOrderCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setOrderCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOrderCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setOrderCreateTime(null);
      }
    }
    if(map.containsKey("order_pay_time")) {
      Object obj = map.get("order_pay_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setOrderPayTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setOrderPayTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOrderPayTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setOrderPayTime(null);
      }
    }
    if(map.containsKey("taoxd_channel")) {
      Object obj = map.get("taoxd_channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaoxdChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_id")) {
      Object obj = map.get("goods_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGoodsId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("phase_info")) {
      Object obj = map.get("phase_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPhaseInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark_tag")) {
      Object obj = map.get("remark_tag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRemarkTag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("merchant_remark")) {
      Object obj = map.get("merchant_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMerchantRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_message")) {
      Object obj = map.get("buyer_message");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerMessage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delivery_time")) {
      Object obj = map.get("delivery_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeliveryTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logistics_no")) {
      Object obj = map.get("logistics_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLogisticsNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logistics_company")) {
      Object obj = map.get("logistics_company");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLogisticsCompany((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("active_compensation")) {
      Object obj = map.get("active_compensation");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setActiveCompensation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("active_compensation_amount")) {
      Object obj = map.get("active_compensation_amount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setActiveCompensationAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("active_compensation_time")) {
      Object obj = map.get("active_compensation_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setActiveCompensationTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setGmtModified(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrgTree((String)obj);
        }
      } else{
      }
    }
  if(map.containsKey("main.id")) {
    Object obj = map.get("main.id");
    if(obj instanceof Long) {
        this.setMainId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setMainId(Long.parseLong((String)obj));
    }
  }
  }
}
