package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * check_erp_back_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-06
 */
public enum CheckErpBackStatus {

    _0("0", "未回传"),
    _1("1", "待回传"),
    _2("2", "已回传");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CheckErpBackStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CheckErpBackStatus fromCode(String code) {
        return Stream.of(CheckErpBackStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
