package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * deal_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-06
 */
public enum DealStatus {

    _1("1", "已处理待对账"),
    _2("2", "待处理"),
    _4("4", "已生成应收订单"),
    _3("3", "待确认应收订单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DealStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DealStatus fromCode(String code) {
        return Stream.of(DealStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
