package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * documents_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-06
 */
public enum DocumentsType {

    _1("1", "汇总应收单"),
    _2("2", "汇总收款单"),
    _3("3", "汇总收款单（收入项）"),
    _4("4", "汇总收款单（费用项）"),
    _5("5", "汇总收款单（其他）"),
    _6("6", "汇总收款单（合同负债）"),
    _7("7", "汇总平台补贴单"),
    _8("8", "汇总应收调整单"),
    _9("9", "费用单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DocumentsType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DocumentsType fromCode(String code) {
        return Stream.of(DocumentsType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
