package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_after_sale_refund_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-06
 */
public enum DyAfterSaleRefundType {

    _0("0", "订单货款/原路退款"),
    _1("1", "货到付款线下退款"),
    _2("2", "备用金"),
    _3("3", "保证金"),
    _4("4", "无需退款"),
    _5("5", "平台垫付"),
    __1("-1", "历史数据");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DyAfterSaleRefundType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyAfterSaleRefundType fromCode(String code) {
        return Stream.of(DyAfterSaleRefundType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
