package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_check_fund_flow
 * </p>
 *
 * @author ultraman
 * @since 2024-12-06
 */
public enum DyCheckFundFlow {

    _0("0", "入账"),
    _1("1", "出账");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DyCheckFundFlow(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyCheckFundFlow fromCode(String code) {
        return Stream.of(DyCheckFundFlow.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
