package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ks_cps_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-06
 */
public enum KsCpsType {

    _0("0", "全部"),
    _1("1", "普通订单"),
    _2("2", "分销订单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    KsCpsType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static KsCpsType fromCode(String code) {
        return Stream.of(KsCpsType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
