package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ks_order_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-06
 */
public enum KsOrderStatus {

    _0("0", "未知状态"),
    _10("10", "待付款"),
    _30("30", "已付款"),
    _40("40", "已发货"),
    _50("50", "已签收"),
    _70("70", "订单成功"),
    _80("80", "订单失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    KsOrderStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static KsOrderStatus fromCode(String code) {
        return Stream.of(KsOrderStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
