package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * match_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-06
 */
public enum MatchType {

    AND("and", "且"),
    OR("or", "或");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MatchType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MatchType fromCode(String code) {
        return Stream.of(MatchType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
