package com.xforceplus.ultraman.app.policymanagement.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pdd_pay_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-06
 */
public enum PddPayType {

    QQ("QQ", "QQ"),
    WEIXIN("WEIXIN", "WEIXIN"),
    ALIPAY("ALIPAY", "ALIPAY"),
    LIANLIANPAY("LIANLIANPAY", "LIANLIANPAY");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PddPayType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PddPayType fromCode(String code) {
        return Stream.of(PddPayType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
